#ifndef RS_EEPROM_H
#define RS_EEPROM_H 
#include <stdint.h>
#include <stdbool.h>

typedef struct {
    uint16_t e_type;
    uint16_t s_control;
    uint16_t o_control;
    int64_t o_limit;
    uint32_t pm_time;
} RsConfig_t;

#define RS_EE_VALID ((uint16_t)0xA5A1u)
extern bool rs_eeprom_init( void );
extern bool rs_eeprom_read(RsConfig_t * pconfig);
extern bool rs_eeprom_write(RsConfig_t * pconfig);
#endif
